/**********************************************************************

Filename    :   Direct3DWin32App.h
Content     :   Simple Direct3D 8 & 9 Win32 Application class
Created     :   January 10, 2008
Authors     :   Michael Antonov

Copyright   :   (c) 2005-2006 Scaleform Corp. All Rights Reserved.

This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR ANY PURPOSE.

**********************************************************************/

#ifndef INC_Direct3DWin32App_H
#define INC_Direct3DWin32App_H

#include <windows.h>

// GFx Includes
#include "GTypes.h"
#include "FxWin32App.h"
// ***** Direct3D Includes

#if defined(GFC_BUILD_DEFINE_NEW) && defined(GFC_DEFINE_NEW)
#undef new
#endif

#ifndef GFC_D3D_VERSION
#define GFC_D3D_VERSION 9
#endif

#if (GFC_D3D_VERSION == 8)
    #include <d3d8.h>
    #include <d3dx8.h>
    #define IDIRECT3DDEVICE IDirect3DDevice8
    #define D3DVIEWPORT D3DVIEWPORT8
    #include "GRendererD3D8.h"
    #define RENDERER GRendererD3D8
#elif (GFC_D3D_VERSION == 9)
    #include <d3d9.h>
    #include <d3dx9.h>
    #define IDIRECT3DDEVICE IDirect3DDevice9
    #define D3DVIEWPORT D3DVIEWPORT9
    #include "GRendererD3D9.h"
    #define RENDERER GRendererD3D9
#elif (GFC_D3D_VERSION == 10)
    #include <d3d10.h>
    #include <d3dx10.h>
    #define IDIRECT3DDEVICE ID3D10Device
    #define D3DVIEWPORT D3D10_VIEWPORT
    #include "GRendererD3D10.h"
    #define RENDERER GRendererD3D10
#else
    #error Define GFC_D3D_VERSION to 8 or 9 or 10
#endif


#if defined(GFC_BUILD_DEFINE_NEW) && defined(GFC_DEFINE_NEW)
#define new GFC_DEFINE_NEW
#endif

class FxDeviceDirect3D;
// ***** Application class
class Direct3DWin32App : public FxWin32App
{
public:

    typedef RENDERER        renderer_type;
    typedef IDIRECT3DDEVICE device_type;
    typedef D3DVIEWPORT     viewport_type;

    // **** Public Interface

    Direct3DWin32App();
    ~Direct3DWin32App();

    virtual bool    CreateRenderer();

    // Presents the data (swaps the back and front buffers)
    virtual void    PresentFrame();

    // Resets the direct3D, return 1 if successful.
    // On successful reset, this function will call InitRenderer again.
    virtual bool    RecreateRenderer();

    virtual void    ResizeWindow(int w, int h);
    // Sizing; by default, re-initalizes the renderer
    //virtual void    OnSize(SInt w, SInt h);
    virtual DisplayStatus  CheckDisplayStatus() const;

    // Sets the new window size and style for full screen, optionally also 
    // resetting renderer. If recreating renderer, will assign Width, Height 
    // in present params and no other values. Returns 1 if recreate succeeded,
    // 0 if it failed. If reset is not specified, function will never fail.
    bool            ConfigureWindow(SInt x, SInt y, SInt w, SInt h,
                                    bool fullScreen, bool recreateRenderer = 1);

    // Draw a text string (specify top-left corner of characters, NOT baseline)
    void            DrawText(int x, int y, const char *ptext, unsigned int color);
    // Compute text size that will be generated by DrawText
    void            CalcDrawTextSize(SInt *pw, SInt *ph, const char *ptext);

    virtual void    SwitchFullScreenMode();
    virtual void    SwitchFSAA(bool on_off);
    
    virtual void    SetVSync(bool isEnabled);
    
    virtual GRenderer* GetRenderer();

#if (GFC_D3D_VERSION == 10)
    void            ChangeFSAA();
    bool            CreateBuffers();
    void            ReleaseBuffers();
#endif
    // *** Implementation
    IDIRECT3DDEVICE*        pDevice;

#if (GFC_D3D_VERSION == 8)
    LPDIRECT3D8             pD3D;
#elif (GFC_D3D_VERSION == 9)
    LPDIRECT3D9             pD3D;
#endif

    // Text/ 2D view rendering support functionality
#if (GFC_D3D_VERSION == 10)
    IDXGIFactory*           pDxgi;
    IDXGISwapChain*         pSwapChain;
    ID3D10RenderTargetView* pRenderTarget;
    ID3D10DepthStencilView* pDepthStencil;
    ID3D10Texture2D*        pDepthStencilBuf;
    DXGI_SWAP_CHAIN_DESC    SwapChainDesc;
    UInt                    FSAASamples;
    UInt                    FSAAQuality;

#else 
    ID3DXFont*              pTextFont;
    ID3DXSprite*            pTextFontSprite;
    D3DPRESENT_PARAMETERS   PresentParams;
#endif


    // Called from a SetupWindow to initialize specific graphic device 
    virtual     bool        SetupWindowDevice();
    // Called from a KillWindow to shutdown specific graphic device 
    virtual     void        KillWindowDevice();

    void                    SetRendererDependentVideoMode();
//private:
    GPtr<renderer_type>     pRenderer;

};


#endif // INC_Direct3DWin32App_H